@extends('layouts.app')

@section('content')
@php if(isset(Auth::user()->avatar)){ $avatar = Auth::user()->avatar; } else{ $avatar = "avatar_g.png"; } @endphp
<div class="row">
                <div class="col-12 col-xl-8">
                    <div class="card card-body border-0 shadow mb-4">
                        <h2 class="h5 mb-4">Informações basicas</h2>
                        <form method="POST" action="{{ route('profile.store') }}" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div>
                                        <label for="nome">Nome</label>
                                        <input class="form-control" id="nome" value="{{ isset($perfil->nome) ? $perfil->nome : null }}" name="nome" type="text" placeholder="Digite seu nome" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div>
                                        <label for="cargo">Cargo</label>
                                        <input class="form-control" id="cargo" name="cargo" value="{{ isset($perfil->cargo) ? $perfil->cargo : null }}" type="text" onPress="recuperarCEP()" placeholder="Digite seu cargo" required>
                                    </div>
                                </div>
                            </div>
                            <div class="row align-items-center">
                                <div class="col-md-6 mb-3">
                                    <label for="birthday">Dt. Nascimento</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <svg class="icon icon-xs" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"></path></svg>
                                        </span>
                                        <input data-datepicker="" class="form-control" id="birthday" name="dtnascimento" value="{{ isset($perfil->dtnascimento) ? $perfil->dtnascimento : null }}" type="text" placeholder="dd/mm/yyyy" required>                                               
                                     </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="sexo">Sexo</label>
                                    @php isset($perfil->sexo) ? $sexoop = $perfil->sexo : null; @endphp
                                    <select class="form-select mb-0" id="sexo" name="sexo" aria-label="sexo">
                                        <option selected>sexo</option>
                                        <option value="1" 
                                            @if ($sexoop == "1") 
                                                selected 
                                            @endif >Feminino</option>
                                        <option value="2" 
                                        @if($sexoop == "2")
                                            selected
                                        @endif >Masculino</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label for="email">Email</label>
                                        <input class="form-control" id="email" disabled value="{{ isset(Auth::user()->email) ?Auth::user()->email : null }}" name="email" type="email" placeholder="name@company.com" required>
                                    </div>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <div class="form-group">
                                        <label for="telefone">Telefone</label>
                                        <input class="form-control" id="telefone" name="telefone" value="{{ isset($perfil->telefone) ? $perfil->telefone : null }}" type="number" placeholder="(16) 99123-4567" required>
                                    </div>
                                </div>
                            </div>
                            <h2 class="h5 my-4">Local</h2>
                            <div class="row">
                                <div class="col-sm-9 mb-3">
                                    <div class="form-group">
                                        <label for="logradouro">Logradouro</label>
                                        <input class="form-control" id="logradouro" name="logradouro" value="{{ isset($perfil->logradouro) ? $perfil->logradouro : null }}" type="text" placeholder="Logradouro" required>
                                    </div>
                                </div>
                                <div class="col-sm-3 mb-3">
                                    <div class="form-group">
                                        <label for="numero">N°</label>
                                        <input class="form-control" id="numero" name="numero" value="{{ isset($perfil->numero) ? $perfil->numero : null }}" type="numero" placeholder="No." required>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-4 mb-3">
                                    <div class="form-group">
                                        <label for="cidade">Cidade</label>
                                        <input class="form-control" id="cidade" value="{{ isset($perfil->cidade) ? $perfil->cidade : null }}" name="cidade" type="text" placeholder="Cidade" required>
                                    </div>
                                </div>
                                <div class="col-sm-4 mb-3">
                                    <label for="uf">UF</label>
                                    <select class="form-select w-100 mb-0" id="uf" name="uf" aria-label="State select example">
                                        <option selected>UF</option>
                                        <option value="AC">Acre</option>
                                        <option value="AL">Alagoas</option>
                                        <option value="AP">Amapá</option>
                                        <option value="AM">Amazonas</option>
                                        <option value="BA">Bahia</option>
                                        <option value="CE">Ceará</option>
                                        <option value="DF">Distrito Federal</option>
                                        <option value="ES">Espírito Santo</option>
                                        <option value="GO">Goiás</option>
                                        <option value="MA">Maranhão</option>
                                        <option value="MT">Mato Grosso</option>
                                        <option value="MS">Mato Grosso do Sul</option>
                                        <option value="MG">Minas Gerais</option>
                                        <option value="PA">Pará</option>
                                        <option value="PB">Paraíba</option>
                                        <option value="PR">Paraná</option>
                                        <option value="PE">Pernambuco</option>
                                        <option value="PI">Piauí</option>
                                        <option value="RJ">Rio de Janeiro</option>
                                        <option value="RN">Rio Grande do Norte</option>
                                        <option value="RS">Rio Grande do Sul</option>
                                        <option value="RO">Rondônia</option>
                                        <option value="RR">Roraima</option>
                                        <option value="SC">Santa Catarina</option>
                                        <option value="SP">São Paulo</option>
                                        <option value="SE">Sergipe</option>
                                        <option value="TO">Tocantins</option>
                                    </select>
                                </div>
                                <div class="col-sm-4">
                                    <div class="form-group">
                                        <label for="cep">CEP</label>
                                        <input class="form-control" id="cep" name="cep" value="{{ isset($perfil->cep) ? $perfil->cep : null }}" type="tel" onkeyup="buscacep(event)" placeholder="CEP" required>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3">
                                <button class="btn btn-gray-800 mt-2 animate-up-2" type="submit">Salvar</button>
                            </div>
                        </form>
                    </div>
 
                </div>
                <div class="col-12 col-xl-4">
                    <div class="row">
                        <div class="col-12 mb-4">
                            <div class="card shadow border-0 text-center p-0">
                                <div class="profile-cover rounded-top" data-background="../assets/img/profile-cover.jpg"></div>
                                <div class="card-body pb-5">
                                    <img src="/avatars/{{ $avatar }}" class="avatar-xl rounded-circle mx-auto mt-n7 mb-4" alt="Neil Portrait">
                                    <h4 class="h3">{{ Auth::user()->name }}</h4>
                                    <h5 class="fw-normal">{{ isset($perfil->cargo) ? $perfil->cargo : null }}</h5>
                                    <p class="text-gray mb-4">{{ isset($perfil->cidade) ? $perfil->cidade : null }}/{{ isset($perfil->uf) ? $perfil->uf : null }}</p>
                                    <a class="btn btn-sm btn-gray-800 d-inline-flex align-items-center me-2" href="#">
                                        <svg class="icon icon-xs me-1" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M8 9a3 3 0 100-6 3 3 0 000 6zM8 11a6 6 0 016 6H2a6 6 0 016-6zM16 7a1 1 0 10-2 0v1h-1a1 1 0 100 2h1v1a1 1 0 102 0v-1h1a1 1 0 100-2h-1V7z"></path></svg>
                                        Connect
                                    </a>
                                    <a class="btn btn-sm btn-secondary" href="#">Send Message</a>
                                </div>
                             </div>
                        </div>
                        <div class="col-12">
                            <div class="card card-body border-0 shadow mb-4">
                                <h2 class="h5 mb-4">Selecione foto perfil</h2>
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                        <!-- Avatar -->
                                        <img class="rounded avatar-xl" src="/avatars/{{ $avatar }}" style="width:80px;height:80px;margin-top: 10px;" alt="alterar avatar">
                                    </div>
                                    <div class="file-field">
                                        <div class="d-flex justify-content-xl-center ms-xl-3">
                                            <div class="d-flex">
                                                <svg class="icon text-gray-500 me-2" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" d="M8 4a3 3 0 00-3 3v4a5 5 0 0010 0V7a1 1 0 112 0v4a7 7 0 11-14 0V7a5 5 0 0110 0v4a3 3 0 11-6 0V7a1 1 0 012 0v4a1 1 0 102 0V7a3 3 0 00-3-3z" clip-rule="evenodd"></path></svg>
                                                <input id="avatar" type="file" class="form-control @error('avatar') is-invalid @enderror" name="avatar" value="{{ old('avatar') }}" required autocomplete="avatar">
                                                <div class="d-md-block text-left">
                                                    <div class="fw-normal text-dark mb-1">Escolha imagem</div>
                                                    <div class="text-gray small">JPG, GIF or PNG. Max size of 800K</div>
                                                </div>
                                            </div>
                                        </div>
                                     </div>                                        
                                </div>
                            </div>
                        </div>
 
                    </div>
                </div>
 </div>
            
        
  
  
@endsection          

@section('script_body')

<script type="text/javascript">

document.addEventListener("DOMContentLoaded", function() {
    buscacep(event);
});
 
 function buscacep(e){
  let total = document.getElementById("cep").value;
  

  if(total.length >=8){ 
    recuperarCEP(total);
    //alert("aa");
  }
};

function recuperarCEP(cep) {
 
     //let cep = input.value.replace(/\D/g, '');
     let url = 'https://viacep.com.br/ws/'+cep+'/json';
    // alert(url);
     const options = {
         method: "GET",
         mode: "cors",
         headers: {
             'content-type': 'application/json;charset=utf-8',
         }
     }
     
        fetch(url, options).then(
            response => response.json()
        ).then(
            data => {
               // console.log(data['localidade'])
                document.getElementById("cidade").value = data['localidade'];
                document.getElementById("uf").value = data['uf'];
                document.getElementById("logradouro").value = data['logradouro'];

                var e = document.getElementById("uf");
                var strUser = e.options[e.selectedIndex].value;
            }
        )
     
 }

</script>

</script>
@endsection